## To show the effect of changing P and I constants
## on PI loop outputs.
## Author: Jim Stevens
## Date: 09042024
## Version 4.3.3

#### Housekeeping ####
rm(list=ls())

library(tidyverse)
library(cowplot)
library(openxlsx)

#### read in data ####

df <- read.xlsx("./Data/Light curves/PID Constants/PID Constants Testing 0721.xlsx",
                sheet = 1)

## Kp plot
KP <- df %>%
  filter(Ki <75&Run_number!=4) %>% # Run # 4 didn't work properly; ki = 50 also included
  group_by(Observation,Kp) %>%
  reframe(Mean=(FqpFmp_1+FqpFmp_2)/(2*1024)) %>%
  ungroup()

kpplot <- ggplot(KP,aes(x=(Observation-1)*5,y=Mean,colour=as.factor(Kp)))+
  geom_line()+
  facet_wrap(~Kp)+
  geom_hline(yintercept=0.52,linetype=2)+
  theme_bw()+
  theme(panel.grid=element_blank(),
        legend.position="none")+
  labs(colour="Kp")+
  xlab("Time ( mins )") +
  ylab("Fq' / Fm'") +
  scale_x_continuous(limits=c(0,50))
  
kpplot
ggsave("./Outputs/Kp_selection.png",kpplot)
save(kpplot,file="./Outputs/kpplot.rdata")
# to get object back, use load(filename) #

## Ki plot

KI <- df %>%
  filter(Kp == 500&Run_number!=1) %>% # First run removed before system initialised
  group_by(Ki,Observation) %>%
  reframe(Mean=(FqpFmp_1+FqpFmp_2)/(2*1024)) %>%
  group_by(Observation,Ki) %>%
  summarise(Mean=mean(Mean))

kiplot <- ggplot(KI,aes(x=(Observation-1)*5,y=Mean,colour=as.factor(Ki))) +
  geom_line()+
  facet_wrap(~Ki)+
  geom_hline(yintercept=0.52,linetype=2)+
  theme_bw()+
  theme(panel.grid=element_blank(),
        legend.position="none")+
  labs(colour="Ki")+
  xlab("Time ( mins )") +
  ylab("Fq' / Fm'") +
  scale_x_continuous(limits=c(0,50))

kiplot
ggsave("./Outputs/Ki_selection.png",kiplot)

save(kiplot,file="./Outputs/kiplot.rdata")
# to get object back, use load(filename) #

## Combined plots
comb <- plot_grid(kpplot,
                  kiplot,
                  align="h",
                  labels="AUTO")
comb
save_plot("./Outputs/Final Plots/Supplementary Information/S2_PI Constants Analysis.png",
          comb,
          base_width=8)
